-- name: [CS] Bottom-Heavy Amy Rose
-- description: Big, scary, and PINK!!!\n\n\\#ff7777\\This Pack requires Character Select\nto use as a Library!

--[[
    API Documentation for Character Select can be found below:
    https://github.com/Squishy6094/character-select-coop/blob/main/API-doc.md

    Use this if you're curious on how anything here works >v<
]]

local function s16(x)
    x = (math.floor(x) & 0xFFFF)
    if x >= 32768 then return x - 65536 end
    return x
end

local  FatsoAnims = {
            [CHAR_ANIM_RUNNING] = 'WADDEL',
			[CHAR_ANIM_WALKING] = 'WADDEL',
[			_G.charSelect.CS_ANIM_MENU] = "mario_anim_cs_menu",
       }
	   
local EYEBALLS = {
    [CHAR_ANIM_IDLE_HEAD_LEFT] = MARIO_EYES_LOOK_RIGHT,
    [CHAR_ANIM_IDLE_HEAD_RIGHT] = MARIO_EYES_LOOK_LEFT,
    [_G.charSelect.CS_ANIM_MENU] = MARIO_EYES_LOOK_DOWN,
}

local PALETTES_AMY = {
    {
        name = "Default",
        [PANTS]  = "FFFFFF",
        [SHIRT]  = "FF0000",
        [GLOVES] = "FFFFFF",
        [SHOES]  = "FF0000",
        [HAIR]   = "FE4683",
        [SKIN]   = "E2875D",
        [CAP]    = "FF0000",
        [EMBLEM] = "FFFFFF",
    },
    {
        name = "Classic",
        [PANTS]  = "f9a42c",
        [SHIRT]  = "3cbc20",
        [GLOVES] = "FFFFFF",
        [SHOES]  = "c0f9f1",
        [HAIR]   = "FE4683",
        [SKIN]   = "E2875D",
        [CAP]    = "FF0000",
        [EMBLEM] = "FFFFFF",
    },
    {
        name = "Gothicc",
        [PANTS]  = "1c1c1c",
        [SHIRT]  = "1c1c1c",
        [GLOVES] = "1c1c1c",
        [SHOES]  = "1c1c1c",
        [HAIR]   = "FE4683",
        [SKIN]   = "E2875D",
        [CAP]    = "1c1c1c",
        [EMBLEM] = "FFFFFF",
    },
    {
        name = "Ulala",
        [PANTS]  = "37d1e5",
        [SHIRT]  = "db8813",
        [GLOVES] = "db8813",
        [SHOES]  = "db8813",
        [HAIR]   = "FE4683",
        [SKIN]   = "E2875D",
        [CAP]    = "37d1e5",
        [EMBLEM] = "FFFFFF",
    },
    {
        name = "Super Form",
        [PANTS]  = "FFFFFF",
        [SHIRT]  = "FF0000",
        [GLOVES] = "FFFFFF",
        [SHOES]  = "FF0000",
        [HAIR]   = "fce21e",
        [SKIN]   = "E2875D",
        [CAP]    = "FF0000",
        [EMBLEM] = "FFFFFF",
    },
}

local E_MODEL_BHAMY = smlua_model_util_get_id("BH_Amy_geo")
local E_MODEL_EMERALD = smlua_model_util_get_id("cakeslice_geo")

local TEX_AMY_ICON = get_texture_info("amy-icon")
local TEX_EMERALD = get_texture_info("cake-icon")
local TEX_AMY_TAG = get_texture_info("amy-tag")

local TEXT_MOD_NAME = "[CS] Rouge the Bat"

BELLYSND1 = audio_sample_load("tummy1.ogg")
BELLYSND2 = audio_sample_load("tummy2.ogg")
BELLYSND3 = audio_sample_load("tummy3.ogg")
BELLYSND4 = audio_sample_load("tummy4.ogg")
BURPSND1 = audio_sample_load("burp_1.ogg")
BURPSND2 = audio_sample_load("burp_2.ogg")
SLOSHSND1 = audio_sample_load("slosh1.ogg")
SLOSHSND2 = audio_sample_load("slosh2.ogg")

local VOICETABLE_AMY = {
    [CHAR_SOUND_OKEY_DOKEY] = 'okay.ogg',
    [CHAR_SOUND_ATTACKED] = {'hey.ogg', 'ow.ogg'},
    [CHAR_SOUND_IMA_TIRED] = 'sigh.ogg',
	[CHAR_SOUND_UH] = 'check.ogg',	
	[CHAR_SOUND_UH2] = 'check.ogg',
	[CHAR_SOUND_EEUH] = 'gghasp.ogg',
    [CHAR_SOUND_HRMM] = 'gotcha.ogg',
    [CHAR_SOUND_PANTING] = 'sigh.ogg',
    [CHAR_SOUND_PANTING_COLD] = 'drown.ogg',
    [CHAR_SOUND_DOH] = {'ow.ogg', 'flor.ogg', 'funny.ogg'},
    [CHAR_SOUND_DROWNING] = 'drown.ogg',
    [CHAR_SOUND_DYING] = {'die.ogg', 'wuu.ogg', 'yawn.ogg'},
    [CHAR_SOUND_GROUND_POUND_WAH] = 'check.ogg',
    [CHAR_SOUND_HAHA] = {'allright.ogg', 'teehee.ogg', 'giggle.ogg', 'toobig.ogg'},
    [CHAR_SOUND_HAHA_2] = 'allright.ogg',
    [CHAR_SOUND_HERE_WE_GO] = {'herewego1.ogg', 'herewego2.ogg', 'herewego3.ogg', 'toobig.ogg'},
    [CHAR_SOUND_HOOHOO] = {'check.ogg', 'go.ogg'},
    [CHAR_SOUND_MAMA_MIA] = {'mamamia1.ogg', 'mamamia2.ogg', 'mamamia3.ogg', 'nope.ogg', 'ohno.ogg', 'ohh.ogg', 'omg.ogg'},
    [CHAR_SOUND_ON_FIRE] = {'scream2.ogg', 'watchit.ogg'},
    [CHAR_SOUND_OOOF] = 'aaa.ogg',
    [CHAR_SOUND_OOOF2] = 'ahh.ogg',
    [CHAR_SOUND_LETS_A_GO] = 'letsago.ogg',
    [CHAR_SOUND_PUNCH_HOO] = 'go.ogg',
    [CHAR_SOUND_PUNCH_WAH] = 'wuu.ogg',
    [CHAR_SOUND_PUNCH_YAH] = 'check.ogg',
    [CHAR_SOUND_SO_LONGA_BOWSER] = {'bowser.ogg', 'ipityyou.ogg', 'seeya.ogg', 'loser.ogg', 'toobig.ogg'},
    [CHAR_SOUND_TWIRL_BOUNCE] = 'woah.ogg',
    [CHAR_SOUND_WAH2] = {'throw.ogg', 'ipityyou.ogg', 'seeya.ogg', 'loser.ogg'},
    [CHAR_SOUND_WHOA] = 'wwoo.ogg',
    [CHAR_SOUND_WAAAOOOW] = 'scream1.ogg',
    [CHAR_SOUND_YAHOO] = 'go.ogg',
    [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = {'yay.ogg', 'wah.ogg','squea.ogg'},
    [CHAR_SOUND_YAH_WAH_HOO] = 'jump.ogg',
    [CHAR_SOUND_YAWNING] = 'yawn.ogg',
}


if _G.charSelectExists then
    CT_AMYMONO = _G.charSelect.character_add("Bottom-Heavy Amy Rose", {"Big, Scary, and PINK!!'", "", "", "", ""}, "Chaothix", {r = 252, g = 108, b = 175}, E_MODEL_BHAMY, CT_MARIO, TEX_AMY_ICON, 1.4)
	_G.charSelect.character_add_celebration_star(E_MODEL_BHAMY, E_MODEL_EMERALD, TEX_EMERALD)
	
	_G.charSelect.character_add_graffiti(CT_AMYMONO, TEX_AMY_TAG)
	
	_G.charSelect.character_set_nickname(CT_AMYMONO, "BH Amy")
	
    -- the following must be hooked for each character added
    _G.charSelect.character_add_voice(E_MODEL_BHAMY, VOICETABLE_AMY)
    hook_event(HOOK_CHARACTER_SOUND, function (m, sound)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_AMY then return _G.charSelect.voice.sound(m, sound) end
    end)
    hook_event(HOOK_MARIO_UPDATE, function (m)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_AMY then return _G.charSelect.voice.snore(m) end
    end)
else
    djui_popup_create("\\#ffffdc\\\n"..TEXT_MOD_NAME.."\nRequires the Character Select Mod\nto use as a Library!\n\nPlease turn on the Character Select Mod\nand Restart the Room!", 6)
end

_G.charSelect.character_add_animations(E_MODEL_BHAMY, FatsoAnims, EYEBALLS)

    for i = 1, #PALETTES_AMY do
        _G.charSelect.character_add_palette_preset(E_MODEL_BHAMY, PALETTES_AMY[i], PALETTES_AMY[i].name)
    end

local function on_character_select_load()

    _G.charSelect.character_hook_moveset(CT_AMYMONO, HOOK_MARIO_UPDATE, amy_update)
	
end

---Moveset!!---


local animFrame = 1
local stamina = 200

--- @param m MarioState
function amy_update(m)

	if m.marioBodyState.eyeState ~= MARIO_EYES_DEAD then

    if s16(m.intendedYaw - m.faceAngle.y) > 0 and m.action == ACT_WALKING then
        m.marioBodyState.eyeState = MARIO_EYES_LOOK_RIGHT
    end
	if s16(m.intendedYaw - m.faceAngle.y) < 0 and m.action == ACT_WALKING then
         m.marioBodyState.eyeState = MARIO_EYES_LOOK_LEFT
    end

	if m.vel.y > 20 and m.action ~= ACT_IDLE and m.action ~= ACT_BEA_BASHATTACK and m.marioBodyState.eyeState ~= MARIO_EYES_LOOK_RIGHT then
		m.marioBodyState.eyeState = MARIO_EYES_LOOK_UP
	end

	if m.vel.y < -8 and m.action ~= ACT_IDLE and m.action ~= ACT_BEA_BASHATTACK and m.action ~= ACT_EXIT_LAND_SAVE_DIALOG then
		m.marioBodyState.eyeState = MARIO_EYES_LOOK_DOWN
	end
	
	end

local heavyLandActs = {
    [ACT_LONG_JUMP_LAND] = true,
    [ACT_DIVE_SLIDE] = true,
    [ACT_GROUND_POUND_LAND] = true,
    [ACT_TRIPLE_JUMP_LAND] = true,
    [ACT_BACKFLIP_LAND] = true,
    [ACT_AIR_HIT_WALL] = true,
    [ACT_BACKWARD_AIR_KB] = true,
    [ACT_HARD_FORWARD_GROUND_KB] = true,
	[ACT_BUTT_STUCK_IN_GROUND] = true,
}
---@param m MarioState

		if m.action == ACT_GROUND_POUND_LAND and m.actionTimer == 0 and m.prevAction ~= ACT_BUTT_STUCK_IN_GROUND then
		spawn_sync_object(id_bhvBowserShockWave, E_MODEL_BOWSER_WAVE, m.pos.x, m.pos.y, m.pos.z, nil)
    end
	
    if m.action == ACT_TRIPLE_JUMP_LAND and m.actionTimer == 0 then
		spawn_sync_object(id_bhvBowserShockWave, E_MODEL_BOWSER_WAVE, m.pos.x, m.pos.y, m.pos.z, nil)
		m.vel.y = 50
		set_mario_action(m, ACT_GROUND_POUND_LAND, 0)
		play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
    end
	
	if m.action == ACT_GROUND_POUND or m.action == ACT_DIVE then
		m.peakHeight = m.pos.y
	end

		if m.actionTimer == 0 then 
        local act = m.action & ACT_ID_MASK
        -- forced heavy land sound
        if heavyLandActs[m.action] ~= nil and m.prevAction ~= ACT_BUTT_STUCK_IN_GROUND  then
		    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
			set_camera_shake_from_point(SHAKE_POS_LARGE, m.pos.x, m.pos.y, m.pos.z)
			m.squishTimer = 8
			m.marioBodyState.eyeState = MARIO_EYES_CLOSED
			audio_sample_play(SLOSHSND2, gMarioStates[0].pos, 1.0)
            play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
			m.actionTimer = m.actionTimer + 1
        elseif act >= 0x066 and act <= 0x07A then -- landing actions
            -- heavy land vs mid-heavy land based on fall distance
            if m.peakHeight - m.pos.y >= 800 then
                play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
			    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
				set_camera_shake_from_point(SHAKE_POS_LARGE, m.pos.x, m.pos.y, m.pos.z)
				m.squishTimer = 8
				m.marioBodyState.eyeState = MARIO_EYES_CLOSED
				audio_sample_play(SLOSHSND2, gMarioStates[0].pos, 1.0)
				set_mario_action(m, ACT_BUTT_STUCK_IN_GROUND, 0)
				m.actionTimer = m.actionTimer + 1
            else
                play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
				set_camera_shake_from_point(SHAKE_POS_MEDIUM, m.pos.x, m.pos.y, m.pos.z)
				m.squishTimer = 2
				audio_sample_play(SLOSHSND1, gMarioStates[0].pos, 1.0)
				m.actionTimer = m.actionTimer + 1
            end
        end
	end


	if m.action == ACT_WALKING then
		stamina = stamina - 1
		set_mario_animation(m, CHAR_ANIM_RUNNING)
		set_anim_to_frame(m, animFrame)
			animFrame = animFrame + 1
        if animFrame >= m.marioObj.header.gfx.animInfo.curAnim.loopEnd then
            animFrame = animFrame - m.marioObj.header.gfx.animInfo.curAnim.loopEnd
			play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
			set_camera_shake_from_point(SHAKE_POS_SMALL, m.pos.x, m.pos.y, m.pos.z)
        end
        if animFrame == 9 then
			play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
			set_camera_shake_from_point(SHAKE_POS_SMALL, m.pos.x, m.pos.y, m.pos.z)
        end
		if stamina == 0 then
			play_character_sound(m, CHAR_SOUND_PANTING)
			set_mario_particle_flags(m, (PARTICLE_WATER_SPLASH), 0)
		end
		if stamina == -150 then
			audio_sample_play(BELLYSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -800 then
			audio_sample_play(BELLYSND2, gMarioStates[0].pos, 1.0)
			stamina = 200
		end
		if stamina == 25 then
			audio_sample_play(BELLYSND3, gMarioStates[0].pos, 1.0)
		end
		if stamina == 50 then
			audio_sample_play(BURPSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -200 then
			audio_sample_play(BURPSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -400 then
			audio_sample_play(BELLYSND4, gMarioStates[0].pos, 1.0)
		end
		if stamina == -60 then
			audio_sample_play(BURPSND2, gMarioStates[0].pos, 1.0)
		end
		if stamina <= 0 and stamina >= -400 then
			m.marioBodyState.eyeState = MARIO_EYES_HALF_CLOSED
		end
		if stamina <= -400 and stamina >= -600 then
			m.marioBodyState.eyeState = MARIO_EYES_LOOK_DOWN
		end
		if stamina <= -600 and stamina >= -800 then
			m.marioBodyState.eyeState = MARIO_EYES_LOOK_DOWN
		end
	else
		stamina = 200
	end

	
	if m.action == ACT_STOMACH_SLIDE_STOP or m.action == ACT_BRAKING or m.action == ACT_STAR_DANCE_EXIT or m.action == ACT_SIDE_FLIP or m.action == ACT_SIDE_FLIP_LAND then
		m.marioBodyState.eyeState = MARIO_EYES_LOOK_DOWN
	end
	
end

hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)